<?php
include_once (get_template_directory() . "/modules/class-tgm-plugin-activation.php");
add_action( 'tgmpa_register', 'tg_require_plugins' );
 
function tg_require_plugins() {
 
    $plugins = array(
	    array(
	        'name'               => 'Grand Restaurant Theme Custom Post Type',
	        'slug'               => 'grandrestaurant-custom-post',
	        'source'             => 'https://assets.themegoods.com/plugins/grandrestaurant-custom-post/grandrestaurant-custom-post-v3.8.3.zip',
	        'required'           => true, 
	        'version'            => '3.8.3',
	    ),
	    array(
	        'name'               => 'Grand Restaurant Theme Elements for Elementor',
	        'slug'               => 'grandrestaurant-elementor',
	        'source'             => 'https://assets.themegoods.com/plugins/grandrestaurant-elementor/grandrestaurant-elementor-v1.7.zip',
	        'required'           => true, 
	        'version'            => '1.7',
	    ),
	    array(
	        'name'      		 => 'Elementor Page Builder',
	        'slug'      		 => 'elementor',
	        'required'  		 => true, 
	    ),
		array(
			'name'      		 => 'Advanced Product Fields (Product Addons) for WooCommerce',
			'slug'      		 => 'advanced-product-fields-for-woocommerce',
			'required'  		 => true, 
		),
	    array(
	        'name'               => 'One Click Demo Import',
	        'slug'      		 => 'one-click-demo-import',
	        'required'           => true, 
	    ),
	    array(
	        'name'               => 'Revolution Slider',
	        'slug'               => 'revslider',
	        'source'             => 'https://assets.themegoods.com/plugins/revslider/revslider-v6.5.19.zip',
	        'required'           => true, 
	        'version'            => '6.5.19',
	    ),
	    array(
			'name'               => 'Envato Market',
			'slug'               => 'envato-market',
			'source'             => 'https://assets.themegoods.com/plugins/envato-market/envato-market-v2.0.7.zip',
			'required'           => true, 
			'version'            => '2.0.7',
		),
		/*array(
			'name'               => 'WooCommerce Extra Product Options',
			'slug'               => 'woocommerce-tm-extra-product-options',
			'source'             => get_template_directory() . '/lib/plugins/woocommerce-tm-extra-product-options.zip',
			'required'           => true, 
			'version'            => '5.0.12.12',
		),*/
	    array(
	        'name'      => 'Custom Fonts',
	        'slug'      => 'custom-fonts',
	        'required'  => true, 
	    ),
	    array(
	        'name'      => 'Contact Form 7',
	        'slug'      => 'contact-form-7',
	        'required'  => true, 
	    ),
	    array(
	        'name'      => 'MailChimp for WordPress',
	        'slug'      => 'mailchimp-for-wp',
	        'required'  => false, 
	    ),
	    array(
	        'name'      => 'Woocommerce',
	        'slug'      => 'woocommerce',
	        'required'  => false, 
	    ),
		/*array(
			'name'      => 'Extra Product Options (Product Addons) for WooCommerce',
			'slug'      => 'woo-extra-product-options',
			'required'  => false, 
		),*/
	    array(
	        'name'      => 'LoftLoader',
	        'slug'      => 'loftloader',
	        'required'  => false, 
	    ),
	    array(
			'name'      => 'Extended Google Map for Elementor',
			'slug'      => 'extended-google-map-for-elementor',
			'required'  => false, 
			'source'    => 'https://assets.themegoods.com/plugins/extended-google-map-for-elementor/extended-google-map-for-elementor-v1.2.2.zip',
			'version'   => '1.2.2',
		),
	);
	
	$config = array(
		'domain'	=> 'grandrestaurant',
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'install-required-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'is_automatic' => true,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        'strings'          => array(
	        'page_title'                      => __( 'Install Required Plugins', 'grandrestaurant' ),
	        'menu_title'                      => __( 'Install Plugins', 'grandrestaurant' ),
	        'installing'                      => __( 'Installing Plugin: %s', 'grandrestaurant' ),
	        'oops'                            => __( 'Something went wrong with the plugin API.', 'grandrestaurant' ),
	        'notice_can_install_required'     => _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.' ),
	        'notice_can_install_recommended'  => _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.' ),
	        'notice_cannot_install'           => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.' ),
	        'notice_can_activate_required'    => _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.' ),
	        'notice_can_activate_recommended' => _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.' ),
	        'notice_cannot_activate'          => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.' ),
	        'notice_ask_to_update'            => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.' ),
	        'notice_cannot_update'            => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.' ),
	        'install_link'                    => _n_noop( 'Begin installing plugin', 'Begin installing plugins' ),
	        'activate_link'                   => _n_noop( 'Activate installed plugin', 'Activate installed plugins' ),
	        'return'                          => __( 'Return to Required Plugins Installer', 'grandrestaurant' ),
	        'plugin_activated'                => __( 'Plugin activated successfully.', 'grandrestaurant' ),
	        'complete'                        => __( 'All plugins installed and activated successfully. %s', 'grandrestaurant' ),
	        'nag_type'                        => 'update-nag'
	    )
    );
 
    tgmpa( $plugins, $config );
 
}
?>