<?php

function grandrestaurant_get_site_domain()
{
	$site_url = site_url();
	$parse = parse_url($site_url);
	
	if(isset($parse['host']) && !empty($parse['host'])) {
		return $parse['host'];
	}
	else {
		return false;
	}
}

/**
*	Custom function to get current URL
**/
function curPageURL() {
	 $pageURL = 'http';
	 if (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
	 $pageURL .= "://";
	 if ($_SERVER["SERVER_PORT"] != "80") {
	  $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
	 } else {
	  $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
	 }
	 return $pageURL;
}
	
function pp_debug($arr)
{
	echo '<pre>';
	print_r($arr);
	echo '</pre>';
}

function wpapi_pagination($pages = '', $range = 4)
{
	 $showitems = ($range * 2)+1;
	 
	 global $paged;
	 if(empty($paged)) $paged = 1;
	 
	 if($pages == '')
	 {
	 global $wp_query;
	 $pages = $wp_query->max_num_pages;
	 if(!$pages)
	 {
	 $pages = 1;
	 }
	 }
	 
	 if(1 != $pages)
	 {
	 echo "<div class=\"pagination\">";
	 if($paged > 2 && $paged > $range+1 && $showitems < $pages) echo "<a href='".get_pagenum_link(1)."'>&laquo; '.".__('First', 'grandrestaurant')."</a>";
	 if($paged > 1 && $showitems < $pages) echo "<a href='".get_pagenum_link($paged - 1)."'>&lsaquo; ".__('Previous', 'grandrestaurant')."</a>";
	 
	 for ($i=1; $i <= $pages; $i++)
	 {
	 if (1 != $pages &&( !($i >= $paged+$range+1 || $i <= $paged-$range-1) || $pages <= $showitems ))
	 {
	 echo ($paged == $i)? "<span class=\"current\">".$i."</span>":"<a href='".get_pagenum_link($i)."' class=\"inactive\">".$i."</a>";
	 }
	 }
	 
	 if ($paged < $pages && $showitems < $pages) echo "<a href=\"".get_pagenum_link($paged + 1)."\">".__('Next', 'grandrestaurant')." &rsaquo;</a>";
	 if ($paged < $pages-1 &&  $paged+$range-1 < $pages && $showitems < $pages) echo "<a href='".get_pagenum_link($pages)."'>".__('Last', 'grandrestaurant')." &raquo;</a>";
	 echo "</div>";
	 }
}

function gen_pagination($total,$currentPage,$baseLink,$nextPrev=true,$limit=10) 
{ 
	if(!$total OR !$currentPage OR !$baseLink) 
	{ 
		return false; 
	} 

	//Total Number of pages 
	$totalPages = ceil($total/$limit); 
	 
	//Text to use after number of pages 
	//$txtPagesAfter = ($totalPages==1)? " page": " pages"; 
	 
	//Start off the list. 
	//$txtPageList = '<br />'.$totalPages.$txtPagesAfter.' : <br />'; 
	 
	//Show only 3 pages before current page(so that we don't have too many pages) 
	$min = ($page - 3 < $totalPages && $currentPage-3 > 0) ? $currentPage-3 : 1; 
	 
	//Show only 3 pages after current page(so that we don't have too many pages) 
	$max = ($page + 3 > $totalPages) ? $totalPages : $currentPage+3; 
	 
	//Variable for the actual page links 
	$pageLinks = ""; 
	
	$baseLinkArr = parse_url($baseLink);
	$start = '';
	
	if(isset($baseLinkArr['query']) && !empty($baseLinkArr['query']))
	{
		$start = '&';
	}
	else
	{
		$start = '?';
	}
	 
	//Loop to generate the page links 
	for($i=$min;$i<=$max;$i++) 
	{ 
		if($currentPage==$i) 
		{ 
			//Current Page 
			$pageLinks .= '<a href="#" class="active">'.$i.'</a>';  
		} 
		elseif($max <= $totalPages OR $i <= $totalPages) 
		{ 
			$pageLinks .= '<a href="'.$baseLink.$start.'page='.$i.'" class="slide">'.$i.'</a>'; 
		} 
	} 
	 
	if($nextPrev) 
	{ 
		//Next and previous links 
		$next = ($currentPage + 1 > $totalPages) ? false : '<a href="'.$baseLink.$start.'page='.($currentPage + 1).'" class="slide">Next</a>'; 
		 
		$prev = ($currentPage - 1 <= 0 ) ? false : '<a href="'.$baseLink.$start.'page='.($currentPage - 1).'" class="slide">Previous</a>'; 
	} 
	 
	if($totalPages > 1)
	{
		return '<br class="clear"/><div class="pagination">'.$txtPageList.$prev.$pageLinks.$next.'</div>'; 
	}
	else
	{
		return '';
	}
	 
} 

function count_shortcode($content = '')
{
	$return = array();
	
	if(!empty($content))
	{
		$pattern = get_shortcode_regex();
		$count = preg_match_all('/'.$pattern.'/s', $content, $matches);
		
		$return['total'] = $count;
		
		if(isset($matches[0]))
		{
			foreach($matches[0] as $match)
			{
				$return['content'][] = substr_replace($match ,"",-1);
			}
		}
	}
	
	return $return;
}
	
/**
*	Setup blog comment style
**/
function pp_comment($comment, $args, $depth) 
{
	$GLOBALS['comment'] = $comment; 
?>
   
	<div class="comment" id="comment-<?php comment_ID() ?>">
		<div class="gravatar">
			 <?php echo get_avatar($comment,$size='60',$default='' ); ?>
		  </div>
	  
		  <div class="right">
			<?php if ($comment->comment_approved == '0') : ?>
				 <em><?php echo _e('(Your comment is awaiting moderation.)', 'grandrestaurant') ?></em>
				 <br />
			  <?php endif; ?>
			
			<?php
				if(!empty($comment->comment_author_url))
				{
			?>
					<a href="<?php echo esc_url($comment->comment_author_url); ?>"><strong style="float:left;margin-top:1px"><?php echo esc_html($comment->comment_author); ?></strong></a>
			<?php
				}
				else
				{
			?>
					<h7><?php echo esc_html($comment->comment_author); ?></h7>
			<?php
				}
			?>
			
			<div class="comment_date"><?php echo date_i18n(THEMEDATEFORMAT, strtotime($comment->comment_date)); ?> <?php echo _e('at', 'grandrestaurant') ?> <?php echo date_i18n(THEMETIMEFORMAT, strtotime($comment->comment_date)); ?></div>
			<?php 
				  if($depth < 3)
				  {
			  ?>
				  <?php comment_reply_link(array_merge( $args, array('depth' => $depth,
'reply_text' =>  __('Reply', 'grandrestaurant'), 'login_text' => __('Login to Reply', 'grandrestaurant'), 'max_depth' => $args['max_depth']))) ?>
			<?php
				}
			?>
			<br class="clear"/>
			  <?php ' '.comment_text() ?>

		  </div>
	</div>
	<?php 
		if($depth == 1)
		{
	?>
	<br class="clear"/><hr/><div style="height:20px"></div>
	<?php
		}
	?>
<?php
}

function pp_ago($timestamp){
   $difference = time() - $timestamp;
   $periods = array("second", "minute", "hour", "day", "week", "month", "years", "decade");
   $lengths = array("60","60","24","7","4.35","12","10");
   for($j = 0; $difference >= $lengths[$j]; $j++)
   $difference /= $lengths[$j];
   $difference = round($difference);
   if($difference != 1) $periods[$j].= "s";
   $text = "$difference $periods[$j] ago";
   return $text;
}


// Substring without losing word meaning and
// tiny words (length 3 by default) are included on the result.
// "..." is added if result do not reach original string length

function pp_substr($str, $length, $minword = 3)
{
	$sub = '';
	$len = 0;
	
	foreach (explode(' ', $str) as $word)
	{
		$part = (($sub != '') ? ' ' : '') . $word;
		$sub .= $part;
		$len += strlen($part);
		
		if (strlen($word) > $minword && strlen($sub) >= $length)
		{
			break;
		}
	}
	
	return $sub . (($len < strlen($str)) ? '...' : '');
}

function pp_strip_shortcodes($the_content)
{
	$the_content = preg_replace("~(?:\[/?)[^/\]]+/?\]~s", '', $the_content); 
	return $the_content;
}


/**
*	Setup recent posts widget
**/
function pp_posts($sort = 'recent', $items = 3, $echo = TRUE, $show_thumb = TRUE) 
{
	$return_html = '';
	
	if($sort == 'recent')
	{
		$posts = get_posts('numberposts='.$items.'&order=DESC&orderby=date&post_type=post&post_status=publish');
		$title = __('Recent Posts', 'grandrestaurant');
	}
	else
	{
		global $wpdb;
		$items = (int)$items;
		
		$query = "SELECT ID, post_title, post_content FROM {$wpdb->prefix}posts WHERE post_type = 'post' AND post_status= 'publish' ORDER BY comment_count DESC LIMIT 0,".$items;
		$posts = $wpdb->get_results($query);
		$title = __('Popular Posts', 'grandrestaurant'); 
	}
	
	if(!empty($posts))
	{
		$return_html.= '<h2 class="widgettitle">'.$title.'</h2>';
		$return_html.= '<ul class="posts blog ';
		
		if($show_thumb)
		{
			$return_html.= 'withthumb ';
		}
		
		$return_html.= '">';
		
		$count_post = count($posts);

			foreach($posts as $post)
			{
				$image_thumb = get_post_meta($post->ID, 'blog_thumb_image_url', true);
				$return_html.= '<li>';
				
				if(!empty($show_thumb) && has_post_thumbnail($post->ID, 'thumbnail'))
				{
					$image_id = get_post_thumbnail_id($post->ID);
					$image_url = wp_get_attachment_image_src($image_id, 'thumbnail', true);
					$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
					
					$return_html.= '<div class="post_circle_thumb"><a href="'.get_permalink($post->ID).'"><img src="'.$image_url[0].'" alt="'.esc_attr($image_alt).'" /></a></div>';
				}
				
				$return_html.= '<a href="'.get_permalink($post->ID).'">'.$post->post_title.'</a><div class="post_attribute">'.get_the_time(THEMEDATEFORMAT, $post->ID).'</div>';
				$return_html.= '</li>';

			}	

		$return_html.= '</ul>';

	}
	
	if($echo)
	{
		echo $return_html;
	}
	else
	{
		return $return_html;
	}
}

function pp_cat_posts($cat_id = '', $items = 5, $echo = TRUE, $show_thumb = TRUE) 
{
	$return_html = '';
	$posts = get_posts('numberposts='.$items.'&order=DESC&orderby=date&category='.$cat_id);
	$title = get_cat_name($cat_id);
	$category_link = get_category_link($cat_id);
	$count_post = count($posts);
	
	if(!empty($posts))
	{

		$return_html.= '<h2 class="widgettitle">'.$title.'</h2>';
		$return_html.= '<ul class="posts blog ';
		
		if($show_thumb)
		{
			$return_html.= 'withthumb ';
		}
		
		$return_html.= '">';

			foreach($posts as $key => $post)
			{
				$return_html.= '<li>';
			
				if(!empty($show_thumb) && has_post_thumbnail($post->ID, 'thumbnails'))
				{
					$image_id = get_post_thumbnail_id($post->ID);
					$image_url = wp_get_attachment_image_src($image_id, 'thumbnails', true);
					$image_alt = get_post_meta($image_id, '_wp_attachment_image_alt', true);
					
					$return_html.= '<div class="post_circle_thumb"><a href="'.get_permalink($post->ID).'"><img class="alignleft frame post_thumb" src="'.$image_url[0].'" alt="'.esc_attr($image_alt).'" /></a></div>';
				}
				
				$return_html.= '<strong class="title"><a href="'.get_permalink($post->ID).'">'.pp_substr($post->post_title, 50).'</a></strong><div class="post_attribute">'.get_the_time(THEMEDATEFORMAT, $post->ID).'</div>';
				$return_html.= '</li>';
			}	

		$return_html.= '</ul><br class="clear"/>';

	}
	
	if($echo)
	{
		echo $return_html;
	}
	else
	{
		return $return_html;
	}
}

function _substr($str, $length, $minword = 3)
{
	$sub = '';
	$len = 0;
	
	foreach (explode(' ', $str) as $word)
	{
		$part = (($sub != '') ? ' ' : '') . $word;
		$sub .= $part;
		$len += strlen($part);
		
		if (strlen($word) > $minword && strlen($sub) >= $length)
		{
			break;
		}
	}
	
	return $sub . (($len < strlen($str)) ? '...' : '');
}

function get_the_content_with_formatting ($more_link_text = '(more...)', $stripteaser = 0, $more_file = '') {

	$pp_blog_read_more_title = get_option('pp_blog_read_more_title'); 		
	if(empty($pp_blog_read_more_title))
	{
		$pp_blog_read_more_title = 'Read More';
	}

	$content = get_the_content('', $stripteaser, $more_file);
	$content = strip_shortcodes($content);
	$content = str_replace(']]>', ']]&gt;', $content);
	$content = '<div class="post_excerpt">'._substr(strip_tags(strip_shortcodes($content)), 320).'</div>';
	return $content;
}

function image_from_description($data) {
	preg_match_all('/<img src="([^"]*)"([^>]*)>/i', $data, $matches);
	return $matches[1][0];
}


function select_image($img, $size) {
	$img = explode('/', $img);
	$filename = array_pop($img);

	// The sizes listed here are the ones Flickr provides by default.  Pass the array index in the

	// 0 for square, 1 for thumb, 2 for small, etc.
	$s = array(
		'_s.', // square
		'_t.', // thumb
		'_m.', // small
		'.',   // medium
		'_b.'  // large
	);

	$img[] = preg_replace('/(_(s|t|m|b))?\./i', $s[$size], $filename);
	return implode('/', $img);
}


function get_flickr($settings) {
	if (!function_exists('MagpieRSS')) {
		// Check if another plugin is using RSS, may not work
		include_once (ABSPATH . WPINC . '/class-simplepie.php');
	}
	
	if(!isset($settings['items']) || empty($settings['items']))
	{
		$settings['items'] = 9;
	}
	
	// get the feeds
	if ($settings['type'] == "user") { $rss_url = 'https://api.flickr.com/services/feeds/photos_public.gne?id=' . $settings['id'] . '&per_page='.$settings['items'].'&format=rss_200'; }
	elseif ($settings['type'] == "favorite") { $rss_url = 'https://api.flickr.com/services/feeds/photos_faves.gne?id=' . $settings['id'] . '&format=rss_200'; }
	elseif ($settings['type'] == "set") { $rss_url = 'https://api.flickr.com/services/feeds/photoset.gne?set=' . $settings['set'] . '&nsid=' . $settings['id'] . '&format=rss_200'; }
	elseif ($settings['type'] == "group") { $rss_url = 'https://api.flickr.com/services/feeds/groups_pool.gne?id=' . $settings['id'] . '&format=rss_200'; }
	elseif ($settings['type'] == "public" || $settings['type'] == "community") { $rss_url = 'https://api.flickr.com/services/feeds/photos_public.gne?tags=' . $settings['tags'] . '&format=rss_200'; }
	else {
		print '<strong>No "type" parameter has been setup. Check your settings, or provide the parameter as an argument.</strong>';
		die();
	}
	
	$flickr_cache_path = THEMEUPLOAD.'/flickr_'.$settings['id'].'_'.$settings['items'].'.cache';
		
	if(file_exists($flickr_cache_path))
	{
		$flickr_cache_timer = intval((time()-filemtime($flickr_cache_path))/60);
	}
	else
	{
		$flickr_cache_timer = 0;
	}
	
	$photos_arr = array();
	
	if(!file_exists($flickr_cache_path) OR $flickr_cache_timer > 15)
	{
		# get rss file
		$feed = new SimplePie($rss_url);
		
		foreach ($feed->get_items() as $key => $item)
		{
			$enclosure = $item->get_enclosure();
			$img = image_from_description($item->get_description()); 
			$thumb_url = select_image($img, 0);
			$large_url = select_image($img, 4);
			
			$photos_arr[] = array(
				'title' => $enclosure->get_title(),
				'thumb_url' => $thumb_url,
				'url' => $large_url,
				'link' => $item->get_link(),
			);
			
			$current = intval($key+1);
			
			if($current == $settings['items'])
			{
				break;
			}
		} 
		
		if(!empty($photos_arr))
		{
			if(file_exists($flickr_cache_path))
			{
				unlink($flickr_cache_path);
			}
			
			$myFile = $flickr_cache_path;
			$fh = fopen($myFile, 'w') or die("can't open file");
			$stringData = serialize($photos_arr);
			fwrite($fh, $stringData);
			fclose($fh);
		}
		else
		{
			$file = file_get_contents($flickr_cache_path, true);
					
			if(!empty($file))
			{
				$photos_arr = unserialize($file);			
			}
		}
	}
	else
	{
		$file = file_get_contents($flickr_cache_path, true);
					
		if(!empty($file))
		{
			$photos_arr = unserialize($file);			
		}
	}

	return $photos_arr;
}

function html2rgb($color)
{
	if ($color[0] == '#')
		$color = substr($color, 1);

	if (strlen($color) == 6)
		list($r, $g, $b) = array($color[0].$color[1],
								 $color[2].$color[3],
								 $color[4].$color[5]);
	elseif (strlen($color) == 3)
		list($r, $g, $b) = array($color[0].$color[0], $color[1].$color[1], $color[2].$color[2]);
	else
		return false;

	$r = hexdec($r); $g = hexdec($g); $b = hexdec($b);

	return array($r, $g, $b);
}

function hex_darker($rgb, $darker=2)
{
	$hash = (strpos($rgb, '#') !== false) ? '#' : '';
	$rgb = (strlen($rgb) == 7) ? str_replace('#', '', $rgb) : ((strlen($rgb) == 6) ? $rgb : false);
	if(strlen($rgb) != 6) return $hash.'000000';
	$darker = ($darker > 1) ? $darker : 1;

	list($R16,$G16,$B16) = str_split($rgb,2);

	$R = sprintf("%02X", floor(hexdec($R16)/$darker));
	$G = sprintf("%02X", floor(hexdec($G16)/$darker));
	$B = sprintf("%02X", floor(hexdec($B16)/$darker));

	return $hash.$R.$G.$B;      
}

function get_image_sizes($sourceImageFilePath, 
  $maxResizeWidth, $maxResizeHeight) {

  // Get width and height of original image
  $size = getimagesize($sourceImageFilePath);
  if($size === FALSE) return FALSE; // Error
  $origWidth = $size[0];
  $origHeight = $size[1];

  // Change dimensions to fit maximum width and height
  $resizedWidth = $origWidth;
  $resizedHeight = $origHeight;
  if($resizedWidth > $maxResizeWidth) {
	$aspectRatio = $maxResizeWidth / $resizedWidth;
	$resizedWidth = round($aspectRatio * $resizedWidth);
	$resizedHeight = round($aspectRatio * $resizedHeight);
  }
  if($resizedHeight > $maxResizeHeight) {
	$aspectRatio = $maxResizeHeight / $resizedHeight;
	$resizedWidth = round($aspectRatio * $resizedWidth);
	$resizedHeight = round($aspectRatio * $resizedHeight);
  }
  
  // Return an array with the original and resized dimensions
  return array($resizedWidth, 
	$resizedHeight);
}

function XML2Array ( $xml , $recursive = false )
{
	if ( ! $recursive )
	{
		$array = simplexml_load_string ( $xml ) ;
	}
	else
	{
		$array = $xml ;
	}
	
	$newArray = array () ;
	$array = ( array ) $array ;
	foreach ( $array as $key => $value )
	{
		$value = ( array ) $value ;
		if ( isset ( $value [ 0 ] ) )
		{
			$newArray [ $key ] = trim ( $value [ 0 ] ) ;
		}
		else
		{
			$newArray [ $key ] = XML2Array ( $value , true ) ;
		}
	}
	return $newArray ;
}

/**
	 * Converts a simpleXML element into an array. Preserves attributes and everything.
	 * You can choose to get your elements either flattened, or stored in a custom index that
	 * you define.
	 * For example, for a given element
	 * <field name="someName" type="someType"/>
	 * if you choose to flatten attributes, you would get:
	 * $array['field']['name'] = 'someName';
	 * $array['field']['type'] = 'someType';
	 * If you choose not to flatten, you get:
	 * $array['field']['@attributes']['name'] = 'someName';
	 * _____________________________________
	 * Repeating fields are stored in indexed arrays. so for a markup such as:
	 * <parent>
	 * <child>a</child>
	 * <child>b</child>
	 * <child>c</child>
	 * </parent>
	 * you array would be:
	 * $array['parent']['child'][0] = 'a';
	 * $array['parent']['child'][1] = 'b';
	 * ...And so on.
	 * _____________________________________
	 * @param simpleXMLElement $xml the XML to convert
	 * @param boolean $flattenValues    Choose wether to flatten values
	 *                                    or to set them under a particular index.
	 *                                    defaults to true;
	 * @param boolean $flattenAttributes Choose wether to flatten attributes
	 *                                    or to set them under a particular index.
	 *                                    Defaults to true;
	 * @param boolean $flattenChildren    Choose wether to flatten children
	 *                                    or to set them under a particular index.
	 *                                    Defaults to true;
	 * @param string $valueKey            index for values, in case $flattenValues was set to
			*                            false. Defaults to "@value"
	 * @param string $attributesKey        index for attributes, in case $flattenAttributes was set to
			*                            false. Defaults to "@attributes"
	 * @param string $childrenKey        index for children, in case $flattenChildren was set to
			*                            false. Defaults to "@children"
	 * @return array the resulting array.
	 */
	function simpleXMLToArray($xml, 
					$flattenValues=true,
					$flattenAttributes = true,
					$flattenChildren=true,
					$valueKey='@value',
					$attributesKey='@attributes',
					$childrenKey='@children'){

		$return = array();
		if(!($xml instanceof SimpleXMLElement)){return $return;}
		$name = $xml->getName();
		$_value = trim((string)$xml);
		if(strlen($_value)==0){$_value = null;};

		if($_value!==null){
			if(!$flattenValues){$return[$valueKey] = $_value;}
			else{$return = $_value;}
		}

		$children = array();
		$first = true;
		foreach($xml->children() as $elementName => $child){
			$value = simpleXMLToArray($child, $flattenValues, $flattenAttributes, $flattenChildren, $valueKey, $attributesKey, $childrenKey);
			if(isset($children[$elementName])){
				if($first){
					$temp = $children[$elementName];
					unset($children[$elementName]);
					$children[$elementName][] = $temp;
					$first=false;
				}
				$children[$elementName][] = $value;
			}
			else{
				$children[$elementName] = $value;
			}
		}
		if(count($children)>0){
			if(!$flattenChildren){$return[$childrenKey] = $children;}
			else{$return = array_merge($return,$children);}
		}

		$attributes = array();
		foreach($xml->attributes() as $name=>$value){
			$attributes[$name] = trim($value);
		}
		if(count($attributes)>0){
			if(!$flattenAttributes){$return[$attributesKey] = $attributes;}
			else{$return = array_merge($return, $attributes);}
		}
		
		return $return;
	}

function theme_queue_js(){
  if (!is_admin()){
	if (!is_page() AND is_singular() AND comments_open() AND (get_option('thread_comments') == 1)) {
	  wp_enqueue_script( 'comment-reply' );
	}
  }
}
add_action('get_header', 'theme_queue_js');


//Clean Up WordPress Shortcode Formatting - important for nested shortcodes
//adjusted from http://donalmacarthur.com/articles/cleaning-up-wordpress-shortcode-formatting/
function parse_shortcode_content( $content ) {

   /* Parse nested shortcodes and add formatting. */
	$content = trim( do_shortcode( shortcode_unautop( $content ) ) );

	/* Remove '' from the start of the string. */
	if ( substr( $content, 0, 4 ) == '' )
		$content = substr( $content, 4 );

	/* Remove '' from the end of the string. */
	if ( substr( $content, -3, 3 ) == '' )
		$content = substr( $content, 0, -3 );

	/* Remove any instances of ''. */
	$content = str_replace( array( '<p></p>' ), '', $content );
	$content = str_replace( array( '<p>  </p>' ), '', $content );

	return $content;
}

function HexToRGB($hex) 
{
	$hex = str_replace("#", "", $hex);
	$color = array();
	
	if(strlen($hex) == 3) {
		$color['r'] = hexdec(substr($hex, 0, 1) . $r);
		$color['g'] = hexdec(substr($hex, 1, 1) . $g);
		$color['b'] = hexdec(substr($hex, 2, 1) . $b);
	}
	else if(strlen($hex) == 6) {
		$color['r'] = hexdec(substr($hex, 0, 2));
		$color['g'] = hexdec(substr($hex, 2, 2));
		$color['b'] = hexdec(substr($hex, 4, 2));
	}
	
	return $color;
}

/*
 * Resize images dynamically using wp built in functions
 * Victor Teixeira
 *
 * php 5.2+
 *
 * Exemplo de uso:
 * 
 * <?php 
 * $thumb = get_post_thumbnail_id(); 
 * $image = vt_resize( $thumb, '', 140, 110, true );
 * ?>
 *
 * @param int $attach_id
 * @param string $img_url
 * @param int $width
 * @param int $height
 * @param bool $crop
 * @return array
 */
if ( !function_exists( 'vt_resize') ) {
	function vt_resize( $attach_id = null, $img_url = null, $width, $height, $crop = false ) {
 
		// this is an attachment, so we have the ID
		if ( $attach_id ) {
 
			$image_src = wp_get_attachment_image_src( $attach_id, 'full' );
			$file_path = get_attached_file( $attach_id );
 
		// this is not an attachment, let's use the image url
		} else if ( $img_url ) {
 
			$file_path = parse_url( $img_url );
			$file_path = $_SERVER['DOCUMENT_ROOT'] . $file_path['path'];
 
			// Look for Multisite Path
			if(file_exists($file_path) === false){
				global $blog_id;
				$file_path = parse_url( $img_url );
				if (preg_match("/files/", $file_path['path'])) {
					$path = explode('/',$file_path['path']);
					foreach($path as $k=>$v){
						if($v == 'files'){
							$path[$k-1] = 'wp-content/blogs.dir/'.$blog_id;
						}
					}
					$path = implode('/',$path);
				}
				$file_path = $_SERVER['DOCUMENT_ROOT'].$path;
			}
			//$file_path = ltrim( $file_path['path'], '/' );
			//$file_path = rtrim( ABSPATH, '/' ).$file_path['path'];
 
			$orig_size = getimagesize( $file_path );
 
			$image_src[0] = $img_url;
			$image_src[1] = $orig_size[0];
			$image_src[2] = $orig_size[1];
		}
 
		$file_info = pathinfo( $file_path );
 
		// check if file exists
		$base_file = $file_info['dirname'].'/'.$file_info['filename'].'.'.$file_info['extension'];
		if ( !file_exists($base_file) )
		 return;
 
		$extension = '.'. $file_info['extension'];
 
		// the image path without the extension
		$no_ext_path = $file_info['dirname'].'/'.$file_info['filename'];
 
		$cropped_img_path = $no_ext_path.'-'.$width.'x'.$height.$extension;
 
		// checking if the file size is larger than the target size
		// if it is smaller or the same size, stop right here and return
		if ( $image_src[1] > $width ) {
 
			// the file is larger, check if the resized version already exists (for $crop = true but will also work for $crop = false if the sizes match)
			if ( file_exists( $cropped_img_path ) ) {
 
				$cropped_img_url = str_replace( basename( $image_src[0] ), basename( $cropped_img_path ), $image_src[0] );
 
				$vt_image = array (
					'url' => $cropped_img_url,
					'width' => $width,
					'height' => $height
				);
 
				return $vt_image;
			}
 
			// $crop = false or no height set
			if ( $crop == false OR !$height ) {
 
				// calculate the size proportionaly
				$proportional_size = wp_constrain_dimensions( $image_src[1], $image_src[2], $width, $height );
				$resized_img_path = $no_ext_path.'-'.$proportional_size[0].'x'.$proportional_size[1].$extension;
 
				// checking if the file already exists
				if ( file_exists( $resized_img_path ) ) {
 
					$resized_img_url = str_replace( basename( $image_src[0] ), basename( $resized_img_path ), $image_src[0] );
 
					$vt_image = array (
						'url' => $resized_img_url,
						'width' => $proportional_size[0],
						'height' => $proportional_size[1]
					);
 
					return $vt_image;
				}
			}
 
			// check if image width is smaller than set width
			$img_size = getimagesize( $file_path );
			if ( $img_size[0] <= $width ) $width = $img_size[0];
 
			// Check if GD Library installed
			if (!function_exists ('imagecreatetruecolor')) {
				echo 'GD Library Error: imagecreatetruecolor does not exist - please contact your webhost and ask them to install the GD library';
				return;
			}
 
			// no cache files - let's finally resize it
			$new_img_path = wp_get_image_editor( $file_path, $width, $height, $crop );			
			$new_img_size = getimagesize( $new_img_path );
			$new_img = str_replace( basename( $image_src[0] ), basename( $new_img_path ), $image_src[0] );
 
			// resized output
			$vt_image = array (
				'url' => $new_img,
				'width' => $new_img_size[0],
				'height' => $new_img_size[1]
			);
 
			return $vt_image;
		}
 
		// default output - without resizing
		$vt_image = array (
			'url' => $image_src[0],
			'width' => $width,
			'height' => $height
		);
 
		return $vt_image;
	}
}

function pp_detect_ie()
{
	if (isset($_SERVER['HTTP_USER_AGENT']) && 
	(strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== false))
		return true;
	else
		return false;
}

function getBrowser() 
{ 
	$u_agent = $_SERVER['HTTP_USER_AGENT']; 
	$bname = 'Unknown';
	$platform = 'Unknown';
	$version= "";

	//First get the platform?
	if (preg_match('/linux/i', $u_agent)) {
		$platform = 'linux';
	}
	elseif (preg_match('/macintosh|mac os x/i', $u_agent)) {
		$platform = 'mac';
	}
	elseif (preg_match('/windows|win32/i', $u_agent)) {
		$platform = 'windows';
	}
	
	// Next get the name of the useragent yes seperately and for good reason
	if(preg_match('/MSIE/i',$u_agent) && !preg_match('/Opera/i',$u_agent)) 
	{ 
		$bname = 'Internet Explorer'; 
		$ub = "MSIE"; 
	}
	elseif(preg_match('/Firefox/i',$u_agent)) 
	{ 
		$bname = 'Mozilla Firefox'; 
		$ub = "Firefox"; 
	} 
	elseif(preg_match('/Chrome/i',$u_agent)) 
	{ 
		$bname = 'Google Chrome'; 
		$ub = "Chrome"; 
	} 
	elseif(preg_match('/Safari/i',$u_agent)) 
	{ 
		$bname = 'Apple Safari'; 
		$ub = "Safari"; 
	} 
	elseif(preg_match('/Opera/i',$u_agent)) 
	{ 
		$bname = 'Opera'; 
		$ub = "Opera"; 
	} 
	elseif(preg_match('/Netscape/i',$u_agent)) 
	{ 
		$bname = 'Netscape'; 
		$ub = "Netscape"; 
	}
	else
	{ 
		$bname = 'Internet Explorer'; 
		$ub = "MSIE"; 
	}
	
	// finally get the correct version number
	$known = array('Version', $ub, 'other');
	$pattern = '#(?<browser>' . join('|', $known) .
	')[/ ]+(?<version>[0-9.|a-zA-Z.]*)#';
	
	// see how many we have
	if(isset($matches['browser']))
	{
		$i = count($matches['browser']);
	}
	else
	{
		$i = 0;
		$matches['version'] = 1;
	}
	if ($i != 1) {
		if (strripos($u_agent,"Version") < strripos($u_agent,$ub)){
			$version= $matches['version'][0];
		}
		elseif(isset($matches['version'][1])) {
			$version= $matches['version'][1];
		}
		else
		{
			$version = 11;
		}
	}
	else {
		$version= $matches['version'][0];
	}
	
	// check if we have a number
	if ($version==null || $version=="") {$version="?";}
	
	return array(
		'userAgent' => $u_agent,
		'name'      => $bname,
		'version'   => $version,
		'platform'  => $platform,
		'pattern'    => $pattern
	);
}

function auto_link_twitter ($tweet)
{
	//Convert urls to <a> links
	$tweet = preg_replace("/([\w]+\:\/\/[\w-?&;#~=\.\/\@]+[\w\/])/", "<a target=\"_blank\" href=\"$1\">$1</a>", $tweet);

	//Convert hashtags to twitter searches in <a> links
	$tweet = preg_replace("/#([A-Za-z0-9\/\.]*)/", "<a target=\"_new\" href=\"https://twitter.com/search?q=$1\">#$1</a>", $tweet);

	//Convert attags to twitter profiles in <a> links
	$tweet = preg_replace("/@([A-Za-z0-9\/\.]*)/", "<a href=\"https://www.twitter.com/$1\">@$1</a>", $tweet);

	return $tweet;
}

function pp_resort_gallery_img($all_photo_arr)
{
	$sorted_all_photo_arr = array();
	$tg_gallery_sort = kirki_get_option('tg_gallery_sort');

	if(!empty($tg_gallery_sort) && !empty($all_photo_arr))
	{
		switch($tg_gallery_sort)
		{
			case 'drag':
			default:
				foreach($all_photo_arr as $key => $gallery_img)
				{
					$sorted_all_photo_arr[$key] = $gallery_img;
				}
			break;
			case 'post_date':
				foreach($all_photo_arr as $key => $gallery_img)
				{
					$gallery_img_meta = get_post($gallery_img);
					$gallery_img_date = strtotime($gallery_img_meta->post_date);
					
					$sorted_all_photo_arr[$gallery_img_date] = $gallery_img;
					krsort($sorted_all_photo_arr);
				}
			break;
			
			case 'post_date_old':
				foreach($all_photo_arr as $key => $gallery_img)
				{
					$gallery_img_meta = get_post($gallery_img);
					$gallery_img_date = strtotime($gallery_img_meta->post_date);
					
					$sorted_all_photo_arr[$gallery_img_date] = $gallery_img;
					ksort($sorted_all_photo_arr);
				}
			break;
			
			case 'rand':
				shuffle($all_photo_arr);
				$sorted_all_photo_arr = $all_photo_arr;
			break;
			
			case 'title':
				foreach($all_photo_arr as $key => $gallery_img)
				{
					$gallery_img_meta = get_post($gallery_img);
					$gallery_img_title = $gallery_img_meta->post_title;
					
					$sorted_all_photo_arr[$gallery_img_title] = $gallery_img;
					ksort($sorted_all_photo_arr);
				}
			break;
		}
		
		return $sorted_all_photo_arr;
	}
	else
	{
		return array();
	}
}

function tg_apply_content($pp_content) {
	$pp_content = apply_filters('the_content', $pp_content);
	$pp_content = str_replace(']]>', ']]>', $pp_content);
	
	return $pp_content;
}

function tg_apply_builder($page_id, $post_type = 'page', $print = TRUE) 
{
	$ppb_form_data_order = get_post_meta($page_id, 'ppb_form_data_order');
	$ppb_page_content = '';
	
	if(isset($ppb_form_data_order[0]))
	{
		$ppb_form_item_arr = explode(',', $ppb_form_data_order[0]);
	}
	
	$ppb_shortcodes = array();
	
	require_once get_template_directory() . "/lib/contentbuilder.shortcode.lib.php";
	
	if(isset($ppb_form_item_arr[0]) && !empty($ppb_form_item_arr[0]))
	{
		$ppb_shortcode_code = '';
	
		foreach($ppb_form_item_arr as $key => $ppb_form_item)
		{
			$ppb_form_item_data = get_post_meta($page_id, $ppb_form_item.'_data');
			$ppb_form_item_size = get_post_meta($page_id, $ppb_form_item.'_size');
			$ppb_form_item_data_obj = json_decode($ppb_form_item_data[0]);
			//pp_debug(rawurldecode($ppb_form_item_data_obj->ppb_text_content));
			$ppb_shortcode_content_name = $ppb_form_item_data_obj->shortcode.'_content';
			
			if(isset($ppb_form_item_data_obj->$ppb_shortcode_content_name))
			{
				$ppb_shortcode_code = '['.$ppb_form_item_data_obj->shortcode.' size="'.$ppb_form_item_size[0].'" ';
				
				//Get shortcode title
				$ppb_shortcode_title_name = $ppb_form_item_data_obj->shortcode.'_title';
				if(isset($ppb_form_item_data_obj->$ppb_shortcode_title_name))
				{
					$ppb_shortcode_code.= 'title="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_title_name), ENT_QUOTES, "UTF-8").'" ';
				}
				
				//Get shortcode attributes
				if(isset($ppb_shortcodes[$ppb_form_item_data_obj->shortcode]))
				{
					$ppb_shortcode_arr = $ppb_shortcodes[$ppb_form_item_data_obj->shortcode];
					
					foreach($ppb_shortcode_arr['attr'] as $attr_name => $attr_item)
					{
						$ppb_shortcode_attr_name = $ppb_form_item_data_obj->shortcode.'_'.$attr_name;
						
						if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_name))
						{
							if(!is_array($ppb_form_item_data_obj->$ppb_shortcode_attr_name))
							{
								$ppb_shortcode_code.= $attr_name.'="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_name)).'" ';
							}
							else
							{
								$shortcode_attr_val_str = '';
								$i = 0;
								$len = count($ppb_form_item_data_obj->$ppb_shortcode_attr_name);
								
								foreach($ppb_form_item_data_obj->$ppb_shortcode_attr_name as $key => $shortcode_attr_val)
								{
									$shortcode_attr_val_str.= $shortcode_attr_val;
									
									if ($i != $len - 1) 
									{
										$shortcode_attr_val_str.= ',';
									}
									
									$i++;
								}
								
								$ppb_shortcode_code.= $attr_name.'="'.esc_attr(rawurldecode($shortcode_attr_val_str)).'" ';
							}
						}
					}
				}

				$ppb_shortcode_code.= ']'.rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_content_name).'[/'.$ppb_form_item_data_obj->shortcode.']';
			}
			else if(isset($ppb_shortcodes[$ppb_form_item_data_obj->shortcode]))
			{
				$ppb_shortcode_code = '['.$ppb_form_item_data_obj->shortcode.' size="'.$ppb_form_item_size[0].'" ';
				
				//Get shortcode title
				$ppb_shortcode_title_name = $ppb_form_item_data_obj->shortcode.'_title';
				if(isset($ppb_form_item_data_obj->$ppb_shortcode_title_name))
				{
					$ppb_shortcode_code.= 'title="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_title_name), ENT_QUOTES, "UTF-8").'" ';
				}
				
				//Get shortcode attributes
				if(isset($ppb_shortcodes[$ppb_form_item_data_obj->shortcode]))
				{
					$ppb_shortcode_arr = $ppb_shortcodes[$ppb_form_item_data_obj->shortcode];
					
					foreach($ppb_shortcode_arr['attr'] as $attr_name => $attr_item)
					{
						$ppb_shortcode_attr_name = $ppb_form_item_data_obj->shortcode.'_'.$attr_name;
						
						if(isset($ppb_form_item_data_obj->$ppb_shortcode_attr_name))
						{
							if(!is_array($ppb_form_item_data_obj->$ppb_shortcode_attr_name))
							{
								$ppb_shortcode_code.= $attr_name.'="'.esc_attr(rawurldecode($ppb_form_item_data_obj->$ppb_shortcode_attr_name)).'" ';
							}
							else
							{
								$shortcode_attr_val_str = '';
								$i = 0;
								$len = count($ppb_form_item_data_obj->$ppb_shortcode_attr_name);
								
								foreach($ppb_form_item_data_obj->$ppb_shortcode_attr_name as $key => $shortcode_attr_val)
								{
									$shortcode_attr_val_str.= $shortcode_attr_val;
									
									if ($i != $len - 1) 
									{
										$shortcode_attr_val_str.= ',';
									}
									
									$i++;
								}
								
								$ppb_shortcode_code.= $attr_name.'="'.esc_attr(rawurldecode($shortcode_attr_val_str)).'" ';
							}
						}
					}
				}
				
				$ppb_shortcode_code.= ']';
			}
			
			if($print)
			{
				echo tg_apply_content($ppb_shortcode_code);
			}
			else
			{
				$ppb_page_content.= tg_apply_content($ppb_shortcode_code);
			}
		}
	}

	if(!$print)
	{
		return $ppb_page_content;
	}
		
}

function get_excerpt_by_id($post_id){
	$the_post = get_post($post_id); //Gets post ID
	$the_excerpt = $the_post->post_content; //Gets post_content to be used as a basis for the excerpt
	$excerpt_length = 35; //Sets excerpt length by word count
	$the_excerpt = strip_tags(strip_shortcodes($the_excerpt)); //Strips tags and images
	$words = explode(' ', $the_excerpt, $excerpt_length + 1);
	if(count($words) > $excerpt_length) :
	array_pop($words);
	array_push($words, '…');
	$the_excerpt = implode(' ', $words);
	endif;
	$the_excerpt = '<p>' . $the_excerpt . '</p>';
	return $the_excerpt;
}

function pp_get_image_id($image_url) {
	$attachment_id = attachment_url_to_postid($image_url);
	return $attachment_id;
}

function aasort (&$array, $key) {
	$sorter=array();
	$ret=array();
	reset($array);
	foreach ($array as $ii => $va) {
		$sorter[$ii]=$va[$key];
	}
	asort($sorter);
	foreach ($sorter as $ii => $va) {
		$ret[$ii]=$array[$ii];
	}
	$array=$ret;
}

if(!function_exists('get_dynamic_sidebar'))
{
	function get_dynamic_sidebar($index = 1)
	{
		$sidebar_contents = "";
		ob_start();
		dynamic_sidebar($index);
		$sidebar_contents = ob_get_clean();
		return $sidebar_contents;
	}
}

function grandrestaurant_update_urls($options,$oldurl,$newurl)
{	
	global $wpdb;
	$results = array();
	$queries = array(
	'content' =>		array("UPDATE $wpdb->posts SET post_content = replace(post_content, %s, %s)",  esc_html__('Content Items (Posts, Pages, Custom Post Types, Revisions)','grandconference') ),
	'excerpts' =>		array("UPDATE $wpdb->posts SET post_excerpt = replace(post_excerpt, %s, %s)", esc_html__('Excerpts','grandconference') ),
	'attachments' =>	array("UPDATE $wpdb->posts SET guid = replace(guid, %s, %s) WHERE post_type = 'attachment'",  esc_html__('Attachments','grandconference') ),
	'links' =>			array("UPDATE $wpdb->links SET link_url = replace(link_url, %s, %s)", esc_html__('Links','grandconference') ),
	'custom' =>			array("UPDATE $wpdb->postmeta SET meta_value = replace(meta_value, %s, %s)",  esc_html__('Custom Fields','grandconference') ),
	'guids' =>			array("UPDATE $wpdb->posts SET guid = replace(guid, %s, %s)",  esc_html__('GUIDs','grandconference') )
	);

	foreach($options as $option){
		if( $option == 'custom' ){
			$n = 0;
			$row_count = $wpdb->get_var( "SELECT COUNT(*) FROM $wpdb->postmeta" );
			$page_size = 10000;
			$pages = ceil( $row_count / $page_size );
			
			for( $page = 0; $page < $pages; $page++ ) {
				$current_row = 0;
				$start = $page * $page_size;
				$end = $start + $page_size;
				$pmquery = "SELECT * FROM $wpdb->postmeta WHERE meta_value <> ''";
				$items = $wpdb->get_results( $pmquery );
				foreach( $items as $item ){
				$value = $item->meta_value;
				if( trim($value) == '' )
					continue;
				
					$edited = grandrestaurant_unserialize_replace( $oldurl, $newurl, $value );
				
					if( $edited != $value ){
						$fix = $wpdb->query( $wpdb->prepare( "UPDATE $wpdb->postmeta SET meta_value = %s WHERE meta_id = %s", $edited, $item->meta_id) );
						if( $fix )
							$n++;
					}
				}
			}
			$results[$option] = array($n, $queries[$option][1]);
		}
		else{
			$result = $wpdb->query( $wpdb->prepare( $queries[$option][0], $oldurl, $newurl) );
			$results[$option] = array($result, $queries[$option][1]);
		}
	}
	return $results;			
}

function grandrestaurant_unserialize_replace( $from = '', $to = '', $data = '', $serialised = false ) 
{
	try {
		if ( is_string( $data ) && ( $unserialized = @unserialize( $data ) ) !== false ) {
			$data = grandrestaurant_unserialize_replace( $from, $to, $unserialized, true );
		}
		elseif ( is_array( $data ) ) {
			$_tmp = array( );
			foreach ( $data as $key => $value ) {
				$_tmp[ $key ] = grandrestaurant_unserialize_replace( $from, $to, $value, false );
			}
			$data = $_tmp;
			unset( $_tmp );
		}
		else {
			if ( is_string( $data ) )
				$data = str_replace( $from, $to, $data );
		}
		if ( $serialised )
			return serialize( $data );
	} catch( Exception $error ) {
	}
	return $data;
}

function pp_recurse_copy($src,$dst) { 
	$dir = opendir($src); 
	@mkdir($dst); 
	while(false !== ( $file = readdir($dir)) ) { 
		if (( $file != '.' ) && ( $file != '..' )) { 
			if ( is_dir($src . '/' . $file) ) { 
				pp_recurse_copy($src . '/' . $file,$dst . '/' . $file); 
			} 
			else { 
				copy($src . '/' . $file,$dst . '/' . $file); 
			} 
		} 
	} 
	closedir($dir); 
}

function tg_get_first_title_word($title, $fontcolor = '') {
	$tg_header_builder_font_mixed = kirki_get_option('tg_header_builder_font_mixed');

	$return_html = '';
	$title_words = explode(" ", $title);
	
	if(isset($title_words[0]) && isset($title_words[1]) && !empty($tg_header_builder_font_mixed))
	{
		$return_html.= '<span class="ppb_title_first" ';
		
		if(!empty($fontcolor))
		{
			$return_html.= 'style="color:'.$fontcolor.';"';
		}
		
		$return_html.= '>'.$title_words[0].'</span>';
		
		foreach($title_words as $key => $title_word)
		{
			if($key > 0)
			{
				$return_html .= $title_word;
				
				if(end($title_words) !== $title_word)
				{
					$return_html .= ' ';
				}
			}
		}
	
		return $return_html;
	}
	else
	{
		return $title;
	}
}

function tg_hex_to_rgb($hex) 
{
	$hex = str_replace("#", "", $hex);
	$color = array();
	
	if(strlen($hex) == 3) {
		$color['r'] = hexdec(substr($hex, 0, 1) . $r);
		$color['g'] = hexdec(substr($hex, 1, 1) . $g);
		$color['b'] = hexdec(substr($hex, 2, 1) . $b);
	}
	else if(strlen($hex) == 6) {
		$color['r'] = hexdec(substr($hex, 0, 2));
		$color['g'] = hexdec(substr($hex, 2, 2));
		$color['b'] = hexdec(substr($hex, 4, 2));
	}
	
	return $color;
}

function tg_is_image($img) { 
	if(!getimagesize($img)){ 
		return FALSE; 
	}else{ 
		return TRUE; 
	} 
}

function tg_fetch_url($uri) {
	$handle = curl_init();

	curl_setopt($handle, CURLOPT_URL, $uri);
	curl_setopt($handle, CURLOPT_POST, false);
	curl_setopt($handle, CURLOPT_BINARYTRANSFER, false);
	curl_setopt($handle, CURLOPT_HEADER, true);
	curl_setopt($handle, CURLOPT_RETURNTRANSFER, true);
	curl_setopt($handle, CURLOPT_CONNECTTIMEOUT, 10);

	$response = curl_exec($handle);
	$hlength  = curl_getinfo($handle, CURLINFO_HEADER_SIZE);
	$httpCode = curl_getinfo($handle, CURLINFO_HTTP_CODE);
	$body     = substr($response, $hlength);

	// If HTTP response is not 200, throw exception
	if ($httpCode != 200) {
		throw new Exception($httpCode);
	}

	return $body;
}

/**
* tg_is_woocommerce_page - Returns true if on a page which uses WooCommerce templates (cart and checkout are standard pages with shortcodes and which are also included)
*
* @access public
* @return bool
*/
function tg_is_woocommerce_page () {
if(  function_exists ( "is_woocommerce" ) && is_woocommerce()){
		return true;
}
$woocommerce_keys   =   array ( "woocommerce_shop_page_id") ;
foreach ( $woocommerce_keys as $wc_page_id ) {
		if ( get_the_ID () == get_option ( $wc_page_id , 0 ) ) {
				return true ;
		}
}
return false;
}

function tg_starts_with($haystack, $needle) 
{
	// search backwards starting from haystack length characters from the end
	return $needle === "" || strrpos($haystack, $needle, -strlen($haystack)) !== FALSE;
}

function tg_check_system()
{
	$has_error = 0;
	$return_html = '<div class="tg_system_status_wrapper">';
	
	$return_html.= '<h4>System Status</h4><br/>';

	//Get max_execution_time
	$max_execution_time = ini_get('max_execution_time');
	$max_execution_time_class = '';
	$max_execution_time_text = '';
	if($max_execution_time < 180)
	{
		$max_execution_time_class = 'tg_error';
		$has_error = 1;
		$max_execution_time_text = '*RECOMMENDED 180';
	}
	$return_html.= '<div class="'.$max_execution_time_class.'">max_execution_time: '.$max_execution_time.' '.$max_execution_time_text.'</div>';
	
	//Get memory_limit
	$memory_limit = ini_get('memory_limit');
	$memory_limit_class = '';
	$memory_limit_text = '';
	if(intval($memory_limit) < 128)
	{
		$memory_limit_class = 'tg_error';
		$has_error = 1;
		$memory_limit_text = '*RECOMMENDED 128M';
	}
	$return_html.= '<div class="'.$memory_limit_class.'">memory_limit: '.$memory_limit.' '.$memory_limit_text.'</div>';
	
	//Get post_max_size
	$post_max_size = ini_get('post_max_size');
	$post_max_size_class = '';
	$post_max_size_text = '';
	if(intval($post_max_size) < 32)
	{
		$post_max_size_class = 'tg_error';
		$has_error = 1;
		$post_max_size_text = '*RECOMMENDED 32M';
	}
	$return_html.= '<div class="'.$post_max_size_class.'">post_max_size: '.$post_max_size.' '.$post_max_size_text.'</div>';
	
	//Get upload_max_filesize
	$upload_max_filesize = ini_get('upload_max_filesize');
	$upload_max_filesize_class = '';
	$upload_max_filesize_text = '';
	if(intval($upload_max_filesize) < 32)
	{
		$upload_max_filesize_class = 'tg_error';
		$has_error = 1;
		$upload_max_filesize_text = '*RECOMMENDED 32M';
	}
	$return_html.= '<div class="'.$upload_max_filesize_class.'">upload_max_filesize: '.$upload_max_filesize.' '.$upload_max_filesize_text.'</div>';
	
	//Get max_input_vars
	$max_input_vars = ini_get('max_input_vars');
	$max_input_vars_class = '';
	$max_input_vars_text = '';
	if(intval($max_input_vars) < 2000)
	{
		$max_input_vars_class = 'tg_error';
		$has_error = 1;
		$max_input_vars_text = '*RECOMMENDED 2000';
	}
	$return_html.= '<div class="'.$max_input_vars_class.'">max_input_vars: '.$max_input_vars.' '.$max_input_vars_text.'</div>';
	
	if(!empty($has_error))
	{
		$return_html.= '<br/><hr/>We are sorry, the demo data could not import properly. It most likely due to PHP configurations on your server. Please fix configuration in System Status which are reported in <span class="tg_error">RED</span>';
	}
	
	$return_html.= '</div>' ;
	
	return $return_html;
}

function grandrestaurant_set_map_api()
{
	//Get Google Map API Key
	$pp_googlemap_api_key = get_option('pp_googlemap_api_key');
	
	if(empty($pp_googlemap_api_key))
	{
		wp_enqueue_script("google_maps", "https://maps.googleapis.com/maps/api/js", false, THEMEVERSION, true);
	}
	else
	{
		wp_enqueue_script("google_maps", "https://maps.googleapis.com/maps/api/js?key=".$pp_googlemap_api_key, false, THEMEVERSION, true);
	}
}

function grandrestaurant_reservation_link()
{
	//check if link reservation button to URL
	$pp_reservation_url = get_option('pp_reservation_url');
	
	if(empty($pp_reservation_url))
	{
		return 'javascript:;';
	}
}

function grandrestaurant_live_builder_begin_wrapper($item_id = '', $item_type = '')
{
	//Check if live content builder mode
	if(isset($_GET['ppb_live']) && !empty($item_id))
	{
		$return_html = '<div id="live_'.esc_attr($item_id).'" class="ppb_live_edit_wrapper '.esc_attr($item_type).'">';
		$return_html.= '<div class="ppb_live_action">';
		
		if(empty($item_type) OR $item_type != 'ppb_divider')
		{
			$return_html.= '<a href="javascript:;" class="ppb_add_after" data-builder-id="'.esc_attr($item_id).'" title="'.esc_html__('Add', 'grandrestaurant' ).'"><span class="dashicons dashicons-arrow-down-alt"></span></a>';
		
			$return_html.= '<a href="javascript:;" class="ppb_edit" data-builder-id="'.esc_attr($item_id).'" title="'.esc_html__('Edit', 'grandrestaurant' ).'"><span class="dashicons dashicons-welcome-write-blog"></span></a>';
			
			$return_html.= '<a href="javascript:;" class="ppb_duplicate" data-builder-id="'.esc_attr($item_id).'" title="'.esc_html__('Duplicate', 'grandrestaurant' ).'"><span class="dashicons dashicons-admin-page"></span></a>';
		}
		
		$return_html.= '<a href="javascript:;" class="ppb_remove" data-builder-id="'.esc_attr($item_id).'" title="'.esc_html__('Remove', 'grandrestaurant' ).'"><span class="dashicons dashicons-no"></span></a>';
		
		$return_html.= '</div>';
		
		return $return_html;
	}
	else
	{
		return '';
	}
}

function grandrestaurant_live_builder_end_wrapper($item_id = '')
{
	//Check if live content builder mode
	if(isset($_GET['ppb_live']) && !empty($item_id))
	{
		return '</div>';
	}
	else
	{
		return '';
	}
}

function grandrestaurant_blur($gdImageResource, $blurFactor = 3)
{
  // blurFactor has to be an integer
  $blurFactor = round($blurFactor);
  
  $originalWidth = imagesx($gdImageResource);
  $originalHeight = imagesy($gdImageResource);

  $smallestWidth = ceil($originalWidth * pow(0.5, $blurFactor));
  $smallestHeight = ceil($originalHeight * pow(0.5, $blurFactor));

  // for the first run, the previous image is the original input
  $prevImage = $gdImageResource;
  $prevWidth = $originalWidth;
  $prevHeight = $originalHeight;

  // scale way down and gradually scale back up, blurring all the way
  for($i = 0; $i < $blurFactor; $i += 1)
  {    
	// determine dimensions of next image
	$nextWidth = $smallestWidth * pow(2, $i);
	$nextHeight = $smallestHeight * pow(2, $i);

	// resize previous image to next size
	$nextImage = imagecreatetruecolor($nextWidth, $nextHeight);
	imagecopyresized($nextImage, $prevImage, 0, 0, 0, 0, 
	  $nextWidth, $nextHeight, $prevWidth, $prevHeight);

	// apply blur filter
	imagefilter($nextImage, IMG_FILTER_GAUSSIAN_BLUR);

	// now the new image becomes the previous image for the next step
	$prevImage = $nextImage;
	$prevWidth = $nextWidth;
	  $prevHeight = $nextHeight;
  }

  // scale back to original size and blur one more time
  imagecopyresized($gdImageResource, $nextImage, 
	0, 0, 0, 0, $originalWidth, $originalHeight, $nextWidth, $nextHeight);
  imagefilter($gdImageResource, IMG_FILTER_GAUSSIAN_BLUR);

  // clean up
  imagedestroy($prevImage);

  // return result
  return $gdImageResource;
}

function grandrestaurant_available_widgets() 
{
	global $wp_registered_widget_controls;

	$widget_controls = $wp_registered_widget_controls;

	$available_widgets = array();

	foreach ( $widget_controls as $widget ) {

		if ( ! empty( $widget['id_base'] ) && ! isset( $available_widgets[$widget['id_base']] ) ) { // no dupes

			$available_widgets[$widget['id_base']]['id_base'] = $widget['id_base'];
			$available_widgets[$widget['id_base']]['name'] = $widget['name'];

		}

	}

	return $available_widgets;
}

function grandrestaurant_import_widgets( $data ) 
{
	global $wp_registered_sidebars;

	// Have valid data?
	// If no data or could not decode
	if ( empty( $data ) || ! is_object( $data ) ) {
		wp_die(
			esc_html__('Import data could not be read. Please try a different file.', 'grandrestaurant' ),
			'',
			array( 'back_link' => true )
		);
	}

	// Get all available widgets site supports
	$available_widgets = grandrestaurant_available_widgets();

	// Get all existing widget instances
	$widget_instances = array();
	foreach ( $available_widgets as $widget_data ) {
		$widget_instances[$widget_data['id_base']] = get_option( 'widget_' . $widget_data['id_base'] );
	}

	// Begin results
	$results = array();

	// Loop import data's sidebars
	foreach ( $data as $sidebar_id => $widgets ) {

		// Skip inactive widgets
		// (should not be in export file)
		if ( 'wp_inactive_widgets' == $sidebar_id ) {
			continue;
		}

		// Check if sidebar is available on this site
		// Otherwise add widgets to inactive, and say so
		if ( isset( $wp_registered_sidebars[$sidebar_id] ) ) {
			$sidebar_available = true;
			$use_sidebar_id = $sidebar_id;
			$sidebar_message_type = 'success';
			$sidebar_message = '';
		} else {
			$sidebar_available = false;
			$use_sidebar_id = 'wp_inactive_widgets'; // add to inactive if sidebar does not exist in theme
			$sidebar_message_type = 'error';
			$sidebar_message = esc_html__('Sidebar does not exist in theme (using Inactive)', 'grandrestaurant' );
		}

		// Result for sidebar
		$results[$sidebar_id]['name'] = ! empty( $wp_registered_sidebars[$sidebar_id]['name'] ) ? $wp_registered_sidebars[$sidebar_id]['name'] : $sidebar_id; // sidebar name if theme supports it; otherwise ID
		$results[$sidebar_id]['message_type'] = $sidebar_message_type;
		$results[$sidebar_id]['message'] = $sidebar_message;
		$results[$sidebar_id]['widgets'] = array();

		// Loop widgets
		foreach ( $widgets as $widget_instance_id => $widget ) {

			$fail = false;

			// Get id_base (remove -# from end) and instance ID number
			$id_base = preg_replace( '/-[0-9]+$/', '', $widget_instance_id );
			$instance_id_number = str_replace( $id_base . '-', '', $widget_instance_id );

			// Does site support this widget?
			if ( ! $fail && ! isset( $available_widgets[$id_base] ) ) {
				$fail = true;
				$widget_message_type = 'error';
				$widget_message = esc_html__('Site does not support widget', 'grandrestaurant' ); // explain why widget not imported
			}

			// Filter to modify settings object before conversion to array and import
			// Leave this filter here for backwards compatibility with manipulating objects (before conversion to array below)
			// Ideally the newer wie_widget_settings_array below will be used instead of this
			$widget = apply_filters( 'wie_widget_settings', $widget ); // object

			// Convert multidimensional objects to multidimensional arrays
			// Some plugins like Jetpack Widget Visibility store settings as multidimensional arrays
			// Without this, they are imported as objects and cause fatal error on Widgets page
			// If this creates problems for plugins that do actually intend settings in objects then may need to consider other approach: https://wordpress.org/support/topic/problem-with-array-of-arrays
			// It is probably much more likely that arrays are used than objects, however
			$widget = json_decode( json_encode( $widget ), true );

			// Does widget with identical settings already exist in same sidebar?
			if ( ! $fail && isset( $widget_instances[$id_base] ) ) {

				// Get existing widgets in this sidebar
				$sidebars_widgets = get_option( 'sidebars_widgets' );
				$sidebar_widgets = isset( $sidebars_widgets[$use_sidebar_id] ) ? $sidebars_widgets[$use_sidebar_id] : array(); // check Inactive if that's where will go

				// Loop widgets with ID base
				$single_widget_instances = ! empty( $widget_instances[$id_base] ) ? $widget_instances[$id_base] : array();
				foreach ( $single_widget_instances as $check_id => $check_widget ) {

					// Is widget in same sidebar and has identical settings?
					if ( in_array( "$id_base-$check_id", $sidebar_widgets ) && (array) $widget == $check_widget ) {

						$fail = true;
						$widget_message_type = 'warning';
						$widget_message = esc_html__('Widget already exists', 'grandrestaurant' ); // explain why widget not imported

						break;

					}

				}

			}

			// No failure
			if ( ! $fail ) {

				// Add widget instance
				$single_widget_instances = get_option( 'widget_' . $id_base ); // all instances for that widget ID base, get fresh every time
				$single_widget_instances = ! empty( $single_widget_instances ) ? $single_widget_instances : array( '_multiwidget' => 1 ); // start fresh if have to
				$single_widget_instances[] = $widget; // add it

					// Get the key it was given
					end( $single_widget_instances );
					$new_instance_id_number = key( $single_widget_instances );

					// If key is 0, make it 1
					// When 0, an issue can occur where adding a widget causes data from other widget to load, and the widget doesn't stick (reload wipes it)
					if ( '0' === strval( $new_instance_id_number ) ) {
						$new_instance_id_number = 1;
						$single_widget_instances[$new_instance_id_number] = $single_widget_instances[0];
						unset( $single_widget_instances[0] );
					}

					// Move _multiwidget to end of array for uniformity
					if ( isset( $single_widget_instances['_multiwidget'] ) ) {
						$multiwidget = $single_widget_instances['_multiwidget'];
						unset( $single_widget_instances['_multiwidget'] );
						$single_widget_instances['_multiwidget'] = $multiwidget;
					}

					// Update option with new widget
					update_option( 'widget_' . $id_base, $single_widget_instances );

				// Assign widget instance to sidebar
				$sidebars_widgets = get_option( 'sidebars_widgets' ); // which sidebars have which widgets, get fresh every time
				$new_instance_id = $id_base . '-' . $new_instance_id_number; // use ID number from new widget instance
				$sidebars_widgets[$use_sidebar_id][] = $new_instance_id; // add new instance to sidebar
				update_option( 'sidebars_widgets', $sidebars_widgets ); // save the amended data

				// Success message
				if ( $sidebar_available ) {
					$widget_message_type = 'success';
					$widget_message = esc_html__('Imported', 'grandrestaurant' );
				} else {
					$widget_message_type = 'warning';
					$widget_message = esc_html__('Imported to Inactive', 'grandrestaurant' );
				}

			}

			// Result for widget instance
			$results[$sidebar_id]['widgets'][$widget_instance_id]['name'] = isset( $available_widgets[$id_base]['name'] ) ? $available_widgets[$id_base]['name'] : $id_base; // widget name or ID if name not available (not supported by site)
			$results[$sidebar_id]['widgets'][$widget_instance_id]['title'] = ! empty( $widget['title'] ) ? $widget['title'] : esc_html__('No Title', 'grandrestaurant' ); // show "No Title" if widget instance is untitled
			$results[$sidebar_id]['widgets'][$widget_instance_id]['message_type'] = $widget_message_type;
			$results[$sidebar_id]['widgets'][$widget_instance_id]['message'] = $widget_message;

		}

	}

	// Return results
	return $results;
}

function grandrestaurant_themegoods_action() 
{
	$pp_verified_envato = get_option('pp_verified_envato');
	
	if(!$pp_verified_envato OR empty($pp_verified_envato))
	{
		if(defined('THEMEGOODS') && THEMEGOODS)
		{
			update_option("pp_verified_envato", true);
			update_option("pp_envato_personal_token", '[ThemeGoods Activation]');
		}
		
		if(defined('ENVATO_HOSTED_SITE')) 
		{
			update_option("pp_verified_envato", true);
			update_option("pp_envato_personal_token", '[Envato Hosted Activation]');
		}
	}
}

if(!function_exists('grandrestaurant_is_registered'))
{
	function grandrestaurant_is_registered() {
		$grandrestaurant_is_registered = get_option("envato_purchase_code_".ENVATOITEMID);
		
		if(!empty($grandrestaurant_is_registered)) {
			return $grandrestaurant_is_registered;
		}
		else {
			return false;
		}
	}
}

function grandrestaurant_register_theme($purchase_code = '') {
	if(!empty($purchase_code)) {
		update_option("envato_purchase_code_".ENVATOITEMID, $purchase_code);
		
		return true;
	}
	else {
		return false;
	}
}

function grandrestaurant_unregister_theme() {
	$result = delete_option("envato_purchase_code_".ENVATOITEMID);
	return $result;
}

if(!function_exists('grandrestaurant_format_price'))
{
	function grandrestaurant_format_price($menu_price = 0, $menu_id = '')
	{
		$return_html = '';
		if(!empty($menu_price))
		{
			$tg_currency = kirki_get_option('tg_default_currency');
			$tg_currency_display = kirki_get_option('tg_currency_display');
			$tg_currency_thousand_sep = kirki_get_option('tg_currency_thousand_sep');
			$tg_currency_decimal_sep = kirki_get_option('tg_currency_decimal_sep');
			$tg_currency_decimal_number = kirki_get_option('tg_currency_decimal_number');
			
			if(!empty($menu_id))
			{
				$menu_price_currency_arr = get_post_meta($menu_id, 'menu_price_currency', true);
				if(!empty($menu_price_currency_arr))
				{
					$tg_currency = $menu_price_currency_arr;
				}
			}
			
			if($tg_currency_display == 'before')
			{
				$return_html.= $tg_currency;
			}
			
			$return_html.= number_format(floatval($menu_price),$tg_currency_decimal_number,$tg_currency_decimal_sep,$tg_currency_thousand_sep);
			
			if($tg_currency_display == 'after')
			{
				$return_html.= $tg_currency;
			}
			
			return $return_html;
		}
		else if(!is_numeric($menu_price))
		{
			$return_html = esc_html($menu_price);
			return $return_html;
		}
		else
		{
			return 0;
		}
	}
}

/**
* grandrestaurant_is_woocommerce_page - Returns true if on a page which uses WooCommerce templates (cart and checkout are standard pages with shortcodes and which are also included)
*
* @access public
* @return bool
*/
function grandrestaurant_is_woocommerce_page() 
{
	if(  function_exists ( "is_woocommerce" ) && is_woocommerce()){
			return true;
	}
	$woocommerce_keys   =   array ( "woocommerce_shop_page_id") ;
	foreach ( $woocommerce_keys as $wc_page_id ) {
			if ( get_the_ID () == get_option ( $wc_page_id , 0 ) ) {
					return true ;
			}
	}
	return false;
}

function grandrestaurant_get_elementor_content($grandrestaurant_content_default = '')
{
	if (class_exists("\\Elementor\\Plugin")) {
		$pluginElementor = \Elementor\Plugin::instance();
		$contentElementor = $pluginElementor->frontend->get_builder_content($grandrestaurant_content_default);
		return $contentElementor;
	}
	else
	{
		return '';
	}
}

function grandrestaurant_is_elementor() {
	$is_elementor = false;
	
	if (class_exists("\\Elementor\\Plugin")) {
		  global $post;
		  $is_elementor = \Elementor\Plugin::$instance->db->is_built_with_elementor($post->ID);
	}
	
	return $is_elementor;
}

function grandrestaurant_get_demo_url($path = '')
{
	$demo_url = 'https://themes.themegoods.com/'.$path;
	return $demo_url;
}

function search_array_by_key_value($array, $search_list) { 
  
	// Create the result array 
	$result = array(); 
  
	  if(is_array($array)) {
		// Iterate over each array element 
		foreach ($array as $key => $value) { 
	  
			// Iterate over each search condition 
			foreach ($search_list as $k => $v) { 
		  
				// If the array element does not meet 
				// the search condition then continue 
				// to the next element 
				if (!isset($value[$k]) || $value[$k] != $v) 
				{ 
					  
					// Skip two loops 
					continue 2; 
				} 
			} 
		  
			// Append array element's key to the 
			//result array 
			$result[] = $value; 
		} 
	}
  
	// Return result  
	return $result; 
} 

function grandrestaurant_elementor_replace_urls( $from, $to ) {
	$from = trim( $from );
	$to = trim( $to );
	
	$is_valid_urls = ( filter_var( $from, FILTER_VALIDATE_URL ) && filter_var( $to, FILTER_VALIDATE_URL ) );
	
	if ( $from != $to && $is_valid_urls) {
		global $wpdb;
	}
	
	$rows_affected = $wpdb->query(
			"UPDATE {$wpdb->postmeta} " .
			"SET `meta_value` = REPLACE(`meta_value`, '" . str_replace( '/', '\\\/', $from ) . "', '" . str_replace( '/', '\\\/', $to ) . "') " .
			"WHERE `meta_key` = '_elementor_data' AND `meta_value` LIKE '[%' ;" );
			
	return $rows_affected;
}
?>