<?php 
header("content-type: application/x-javascript"); 
$absolute_path = __FILE__;
$path_to_file = explode( 'wp-content', $absolute_path );
$path_to_wp = $path_to_file[0];
require_once( $path_to_wp.'/wp-load.php' );

$pp_contact_enable_captcha = get_option('pp_contact_enable_captcha');

//Get contact form ID
$contact_form_id = 'tg_reservation_form';
$response_id = 'reponse_msg';

if(isset($_GET['form']))
{
	$contact_form_id.= '_'.$_GET['form'];
	$response_id.= '_'.$_GET['form'];
}
?>

jQuery(document).ready(function() {
	jQuery('form#<?php echo esc_js($contact_form_id); ?>').submit(function() {
		jQuery('#<?php echo esc_js($response_id); ?> ul li.error').remove();
		
		var hasError = false;
		jQuery('form#<?php echo esc_js($contact_form_id); ?> .required_field').each(function() {
			if(jQuery.trim(jQuery(this).val()) == '' && !jQuery(this).hasClass('gdpr')) {
				var labelText = jQuery(this).prev('label').text();
				jQuery('#<?php echo esc_js($response_id); ?> ul').append('<li class="error"><?php echo _e( 'Please enter', 'grandrestaurant' ); ?> '+labelText+'</li>');
				hasError = true;
			} else if(jQuery(this).hasClass('gdpr') && !jQuery(this).is(':checked')) {
				var labelText = jQuery(this).next('label').text();
				jQuery('#<?php echo esc_js($response_id); ?> ul').append('<li class="error"><?php echo esc_html_e('Please check', 'grandrestaurant' ); ?> '+labelText+'</li>');
				hasError = true;
			} else if(jQuery(this).hasClass('email')) {
				var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
				if(!emailReg.test(jQuery.trim(jQuery(this).val()))) {
					var labelText = jQuery(this).prev('label').text();
					jQuery('#<?php echo esc_js($response_id); ?> ul').append('<li class="error"><?php echo _e( 'Please enter valid', 'grandrestaurant' ); ?> '+labelText+'</li>');
					hasError = true;
				}
			}
		});
		if(!hasError) {
			var contactData = jQuery('#<?php echo esc_js($contact_form_id); ?>').serialize();

			jQuery('#contact_submit_btn').fadeOut('normal', function() {
				jQuery(this).parent().append('<i class="fa fa-circle-o-notch fa-spin"></i>');
			});
 			
 			jQuery.ajax({
			    type: 'POST',
			    url: tgAjax.ajaxurl,
			    data: contactData+'&tg_security='+tgAjax.ajax_nonce,
			    success: function(results){
			    	jQuery('#<?php echo esc_js($contact_form_id); ?>').hide();
			    	jQuery('#<?php echo esc_js($response_id); ?>').html(results);
			    }
			});
		}
		
		return false;
		
	});
});