<?php
	$post_type = get_post_type();
	global $page_gallery_id;
	if(!empty($page_gallery_id))
	{
		$post_type = 'galleries';
	}
	
	$show_share = FALSE;

	switch($post_type)
	{
		case 'post':
			$show_share = TRUE;
		break;
		
		case 'galleries':
			$show_share = TRUE;
		break;
		
		case 'projects':
			$show_share = TRUE;
		break;
		
		case 'attachment':
			$show_share = TRUE;
		break;
		
		
		case 'product':
			$show_share = FALSE;
		break;
	}
    
    if($show_share)
    {
    	$pin_thumb = wp_get_attachment_image_src($post->ID, 'gallery_4', true);
    	if(!isset($pin_thumb[0]))
    	{
	    	$pin_thumb[0] = '';
    	}
    	
    	global $share_display_inline;
?>
<div id="social_share_wrapper" <?php if($share_display_inline) { ?>class="inline"<?php } ?>>
	<ul>
		<li><a class="tooltip" title="<?php _e( 'Share On Facebook', 'grandrestaurant' ); ?>" target="_blank" href="https://www.facebook.com/sharer/sharer.php?u=<?php echo get_permalink(); ?>"><i class="fa fa-facebook marginright"></i></a></li>
		<li><a class="tooltip" title="<?php _e( 'Share On Twitter', 'grandrestaurant' ); ?>" target="_blank" href="https://twitter.com/intent/tweet?original_referer=<?php echo get_permalink(); ?>&url=<?php echo get_permalink(); ?>"><i class="fa fa-twitter marginright"></i></a></li>
		<li><a class="tooltip" title="<?php _e( 'Share On Pinterest', 'grandrestaurant' ); ?>" target="_blank" href="https://www.pinterest.com/pin/create/button/?url=<?php echo urlencode(get_permalink()); ?>&media=<?php echo urlencode($pin_thumb[0]); ?>"><i class="fa fa-pinterest marginright"></i></a></li>
	</ul>
</div>
<?php
    }
?>